/*
 * Decompiled with CFR 0.152.
 */
public class IntShortHashMap {
    public static final int DEFAULT_LOAD_FACTOR = 75;
    public static final int SUB_ELEMENT_SIZE = 3;
    private final int loadFactor;
    private Element[] buckets;
    private final boolean isPowerOfTwo;
    private int size;

    public IntShortHashMap(int n) {
        this(n, 75);
    }

    public IntShortHashMap(int n, int n2) {
        n = n * 100 / n2;
        int n3 = 1;
        while (n > n3) {
            n3 <<= 1;
        }
        this.isPowerOfTwo = n3 == n;
        this.buckets = new Element[n];
        this.loadFactor = n2;
    }

    public boolean put(int n, short s) {
        int n2;
        Element element;
        if (this.size * 100 / this.buckets.length > this.loadFactor) {
            this.increaseSize();
        }
        if ((element = this.buckets[n2 = this.isPowerOfTwo ? n & Integer.MAX_VALUE & this.buckets.length - 1 : (n & Integer.MAX_VALUE) % this.buckets.length]) == null) {
            element = new Element(n, new short[3]);
            element.values[0] = s;
            element.size = (short)(element.size + 1);
            this.buckets[n2] = element;
            ++this.size;
            return true;
        }
        Element element2 = element;
        do {
            if (element.key == n) {
                element.size = (short)(element.size + 1);
                if (element.size == element.values.length) {
                    short[] sArray = new short[element.values.length * 2];
                    System.arraycopy(element.values, 0, sArray, 0, element.values.length);
                    element.values = sArray;
                }
                element.values[element.size - 1] = s;
                return true;
            }
            element2 = element;
        } while ((element = element.next) != null);
        element = new Element(n, new short[3]);
        element.values[0] = s;
        element.size = (short)(element.size + 1);
        this.buckets[n2] = element;
        ++this.size;
        element2.next = element;
        return true;
    }

    public Element get(int n) {
        int n2 = this.isPowerOfTwo ? n & Integer.MAX_VALUE & this.buckets.length - 1 : (n & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[n2];
        if (element == null) {
            return null;
        }
        do {
            if (element.key != n) continue;
            return element;
        } while ((element = element.next) != null);
        return null;
    }

    public short remove(int n) {
        int n2 = this.isPowerOfTwo ? n & Integer.MAX_VALUE & this.buckets.length - 1 : (n & Integer.MAX_VALUE) % this.buckets.length;
        Element element = this.buckets[n2];
        if (element == null) {
            return -1;
        }
        Element element2 = null;
        do {
            if (element.key == n) {
                if (element2 == null) {
                    this.buckets[n2] = element.next;
                } else {
                    element2.next = element.next;
                }
                --this.size;
                return 1;
            }
            element2 = element;
        } while ((element = element.next) != null);
        return -1;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(int n) {
        return this.get(n) != null;
    }

    public void clear() {
        int n = 0;
        while (n < this.buckets.length) {
            this.buckets[n] = null;
            ++n;
        }
        this.size = 0;
    }

    public int[] keys() {
        int[] nArray = new int[this.size];
        int n = 0;
        int n2 = 0;
        while (n2 < this.buckets.length) {
            Element element = this.buckets[n2];
            while (element != null) {
                nArray[n] = element.key;
                ++n;
                element = element.next;
            }
            ++n2;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    private void increaseSize() {
        var1_1 = this.isPowerOfTwo != false ? this.buckets.length << 1 : (this.buckets.length << 1) - 1;
        var2_2 = new Element[var1_1];
        var3_3 = 0;
        while (var3_3 < this.buckets.length) {
            var4_4 = this.buckets[var3_3];
            while (var4_4 != null) {
                block3: {
                    var5_5 = this.isPowerOfTwo != false ? var4_4.key & 0x7FFFFFFF & var1_1 - 1 : (var4_4.key & 0x7FFFFFFF) % var1_1;
                    var6_6 = var2_2[var5_5];
                    if (var6_6 != null) ** GOTO lbl13
                    var2_2[var5_5] = var4_4;
                    break block3;
lbl-1000:
                    // 1 sources

                    {
                        var6_6 = var6_6.next;
lbl13:
                        // 2 sources

                        ** while (var6_6.next != null)
                    }
lbl14:
                    // 1 sources

                    var6_6.next = var4_4;
                }
                var7_7 = var4_4;
                var4_4 = var4_4.next;
                var7_7.next = null;
            }
            ++var3_3;
        }
        this.buckets = var2_2;
    }

    public static final class Element {
        public final int key;
        public short[] values;
        public short size;
        public Element next;

        public Element(int n, short[] sArray) {
            this.key = n;
            this.values = sArray;
        }
    }
}

