/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public final class ZipFile {
    private static final int TYPE_GZIP = 1;
    private boolean inStreamEnded;
    private byte status;
    private static final byte EXPECTING_HEADER = 0;
    private static final byte EXPECTING_DATA = 1;
    private static final byte EXPECTING_CHECK = 2;
    private static final byte FINISHED = 3;
    private boolean hash;
    private boolean validData;
    private int crc32;
    private int type;
    private boolean BFINAL;
    private int BTYPE;
    private byte[] window = new byte[32768];
    private int pProcessed;
    private long allPocessed;
    byte[] outBuff;
    private int buffsize;
    int outEnd;
    int lastEnd;
    int outStart;
    private int B0len;
    long[] smallCodeBuffer;
    static final byte BL = 8;
    short[] huffmanTree;
    short[] distHuffTree;
    private static final boolean debug = false;
    private static final boolean CRC = false;
    private static final boolean GZIP = false;
    byte[] tmpRef = new byte[8];
    private int offset;
    int datalen;
    public byte[] bytes;
    Vector entries;

    public ZipFile(String string) throws IOException {
        this(string.startsWith("/") ? ZipFile.loadJar(string) : ZipFile.loadFile(string), 0, false, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadFile(String string) {
        byte[] byArray;
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)string, (int)1);
            if (!fileConnection.exists()) return null;
            if (fileConnection.isDirectory()) return null;
            if (!fileConnection.canRead()) return null;
            byte[] byArray2 = new byte[(int)fileConnection.fileSize()];
            DataInputStream dataInputStream = fileConnection.openDataInputStream();
            dataInputStream.readFully(byArray2);
            dataInputStream.close();
            byArray = byArray2;
            if (fileConnection == null) return byArray;
        }
        catch (Throwable throwable) {
            try {
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (fileConnection != null) {
                    try {
                        fileConnection.close();
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
        try {
            fileConnection.close();
            return byArray;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadJar(String string) {
        byte[] byArray2;
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) return null;
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[inputStream.available()];
            dataInputStream.readFully(byArray);
            dataInputStream.close();
            byArray2 = byArray;
        }
        catch (Throwable throwable) {
            try {
                return null;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable3) {}
            }
        }
        try {
            inputStream.close();
            return byArray2;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return byArray2;
    }

    public ZipFile(byte[] byArray, int n, boolean bl, boolean bl2) throws IOException {
        this(byArray, 1024, n, bl, bl2);
    }

    public ZipFile(byte[] byArray, int n, int n2, boolean bl, boolean bl2) throws IOException {
        if (byArray == null || bl2 && byArray.length < 23) {
            throw new IOException();
        }
        this.ContDataInputStream(byArray, byArray.length);
        if (bl2) {
            this.endsys();
        }
        this.inf_reset();
        this.hash = bl;
        this.type = n2;
        this.huffmanTree = new short[1152];
        this.distHuffTree = new short[128];
        this.buffsize = n;
        this.outBuff = new byte[n + 300];
    }

    private static void skipheader(ZipFile zipFile) throws IOException {
        if (zipFile.readbuf() != 31 || zipFile.readbuf() != 139 || zipFile.readbuf() != 8) {
            throw new IOException("0");
        }
        int n = zipFile.readbuf();
        zipFile.skipbuf(6);
        if ((n & 4) == 4) {
            zipFile.skipbuf(zipFile.readbuf() | zipFile.readbuf() << 8);
        }
        if ((n & 8) == 8) {
            while (zipFile.readbuf() != 0) {
            }
        }
        if ((n & 0x10) == 16) {
            while (zipFile.readbuf() != 0) {
            }
        }
        if ((n & 2) == 2) {
            zipFile.skipbuf(2);
        }
    }

    final void inf_reset() {
        this.inStreamEnded = false;
        this.status = 0;
        this.smallCodeBuffer = new long[2];
        this.pProcessed = 0;
        this.allPocessed = 0L;
        this.outEnd = 0;
        this.lastEnd = 0;
        this.outStart = 0;
    }

    public void close() {
        this.bytes = null;
        this.entries = null;
        this.smallCodeBuffer = null;
        this.huffmanTree = null;
        this.distHuffTree = null;
    }

    private void copyFromWindow(int n, int n2, byte[] byArray, int n3) {
        if (n + n2 < this.window.length) {
            System.arraycopy(this.window, n, byArray, 0 + n3, n2);
        } else {
            System.arraycopy(this.window, n, byArray, 0 + n3, this.window.length - n);
            System.arraycopy(this.window, 0, byArray, this.window.length - n + n3, n2 - (this.window.length - n));
        }
    }

    private void copyIntoWindow(int n, int n2, byte[] byArray, int n3) {
        if (n2 + n < this.window.length) {
            System.arraycopy(byArray, n3, this.window, n, n2);
        } else {
            System.arraycopy(byArray, n3, this.window, n, this.window.length - n);
            System.arraycopy(byArray, n3 + (this.window.length - n), this.window, 0, n2 - (this.window.length - n));
        }
    }

    private void inflate() throws IOException {
        int n = 0;
        byte[] byArray = this.window;
        byte[] byArray2 = this.outBuff;
        System.arraycopy(byArray2, this.outStart, byArray2, 0, this.outEnd - this.outStart);
        this.outEnd -= this.outStart;
        this.outStart = 0;
        this.lastEnd = this.outEnd;
        if (this.B0len == 0 && this.smallCodeBuffer[1] < 15L) {
            this.refillSmallCodeBuffer();
        }
        while (byArray2.length - this.outEnd > 300 && (this.smallCodeBuffer[1] > 0L || this.B0len > 0) && this.status != 3) {
            int n2;
            if (this.status == 0) {
                this.processHeader();
            }
            if (this.status == 1) {
                if (this.BTYPE == 0) {
                    if (this.B0len > 0) {
                        int n3 = byArray2.length - this.outEnd > this.B0len ? this.B0len : byArray2.length - this.outEnd;
                        n3 = this.readbuf(byArray2, this.outEnd, n3);
                        this.copyIntoWindow(this.pProcessed, n3, byArray2, this.outEnd);
                        this.outEnd += n3;
                        this.pProcessed = this.pProcessed + n3 & Short.MAX_VALUE;
                        this.B0len -= n3;
                    } else {
                        this.status = this.BFINAL ? (byte)2 : (byte)0;
                        if (this.smallCodeBuffer[1] < 15L) {
                            this.refillSmallCodeBuffer();
                        }
                    }
                } else {
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                    if ((n = ZipOutputStream.deHuffNext(this.smallCodeBuffer, this.huffmanTree)) < 256) {
                        byArray[this.pProcessed] = (byte)n;
                        this.pProcessed = this.pProcessed + 1 & Short.MAX_VALUE;
                        byArray2[this.outEnd] = (byte)n;
                        ++this.outEnd;
                    } else if (n != 256) {
                        int n4;
                        if (n > 285) {
                            throw new IOException("1");
                        }
                        int n5 = this.popSmallBuffer(ZipOutputStream.LENGTH_CODE[n - 257 << 1]);
                        n5 += ZipOutputStream.LENGTH_CODE[(n - 257 << 1) + 1];
                        if (this.smallCodeBuffer[1] < 15L) {
                            this.refillSmallCodeBuffer();
                        }
                        n = ZipOutputStream.deHuffNext(this.smallCodeBuffer, this.distHuffTree);
                        int n6 = this.popSmallBuffer(ZipOutputStream.DISTANCE_CODE[n << 1]);
                        n4 += (n4 = this.pProcessed - (n6 += ZipOutputStream.DISTANCE_CODE[(n << 1) + 1])) < 0 ? byArray.length : 0;
                        int n7 = n5 / n6;
                        int n8 = n5 - n6 * n7;
                        n2 = 0;
                        while (n2 < n7) {
                            this.copyFromWindow(n4, n6, byArray2, this.outEnd);
                            this.copyIntoWindow(this.pProcessed, n6, byArray2, this.outEnd);
                            this.outEnd += n6;
                            this.pProcessed = this.pProcessed + n6 & Short.MAX_VALUE;
                            ++n2;
                        }
                        this.copyFromWindow(n4, n8, byArray2, this.outEnd);
                        this.copyIntoWindow(this.pProcessed, n8, byArray2, this.outEnd);
                        this.outEnd += n8;
                        this.pProcessed = this.pProcessed + n8 & Short.MAX_VALUE;
                    } else {
                        this.status = this.BFINAL ? (byte)2 : (byte)0;
                    }
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                }
            }
            if (this.status != 2) continue;
            this.status = (byte)3;
            this.allPocessed = this.allPocessed + (long)this.outEnd - (long)this.lastEnd & 0xFFFFFFFFL;
            this.popSmallBuffer(this.smallCodeBuffer[1] & 7L);
            n2 = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8 | this.popSmallBuffer(8L) << 16 | this.popSmallBuffer(8L) << 24;
            int n9 = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8 | this.popSmallBuffer(8L) << 16 | this.popSmallBuffer(8L) << 24;
            boolean bl = this.validData = (long)n9 == this.allPocessed;
        }
        if (this.status != 3) {
            this.allPocessed = this.allPocessed + (long)this.outEnd - (long)this.lastEnd & 0xFFFFFFFFL;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processHeader() throws IOException {
        block23: {
            block24: {
                block22: {
                    var5_1 = new int[30];
                    var6_2 = new int[30];
                    var7_3 = new byte[30];
                    var8_4 = new int[286];
                    var9_5 = new int[286];
                    var10_6 = new byte[286];
                    this.BFINAL = this.popSmallBuffer(1L) == 1;
                    this.BTYPE = this.popSmallBuffer(2L);
                    if (this.BTYPE == 3) {
                        throw new IllegalArgumentException();
                    }
                    if (this.BTYPE != 1) break block22;
                    ZipOutputStream.genFixedTree(var8_4, var10_6, var5_1, var7_3);
                    var11_7 = 0;
                    while (var11_7 < 286) {
                        var9_5[var11_7] = var11_7;
                        ++var11_7;
                    }
                    var11_7 = 0;
                    while (var11_7 < 30) {
                        var6_2[var11_7] = var11_7;
                        ++var11_7;
                    }
                    ZipOutputStream.convertTable2Tree(var8_4, var10_6, var9_5, this.huffmanTree);
                    ZipOutputStream.convertTable2Tree(var5_1, var7_3, var6_2, this.distHuffTree);
                    break block23;
                }
                if (this.BTYPE != 2) break block24;
                var2_9 = this.popSmallBuffer(5L);
                var3_10 = this.popSmallBuffer(5L);
                var4_11 = this.popSmallBuffer(4L);
                v0 = new int[19];
                v0[0] = 16;
                v0[1] = 17;
                v0[2] = 18;
                v0[4] = 8;
                v0[5] = 7;
                v0[6] = 9;
                v0[7] = 6;
                v0[8] = 10;
                v0[9] = 5;
                v0[10] = 11;
                v0[11] = 4;
                v0[12] = 12;
                v0[13] = 3;
                v0[14] = 13;
                v0[15] = 2;
                v0[16] = 14;
                v0[17] = 1;
                v0[18] = 15;
                var11_8 = v0;
                v1 = new int[19];
                v1[1] = 1;
                v1[2] = 2;
                v1[3] = 3;
                v1[4] = 4;
                v1[5] = 5;
                v1[6] = 6;
                v1[7] = 7;
                v1[8] = 8;
                v1[9] = 9;
                v1[10] = 10;
                v1[11] = 11;
                v1[12] = 12;
                v1[13] = 13;
                v1[14] = 14;
                v1[15] = 15;
                v1[16] = 16;
                v1[17] = 17;
                v1[18] = 18;
                var12_12 = v1;
                var13_13 = new byte[19];
                var14_14 = new int[19];
                var15_15 = 0;
                while (var15_15 < var4_11 + 4) {
                    var13_13[var11_8[var15_15]] = (byte)this.popSmallBuffer(3L);
                    ++var15_15;
                }
                ZipOutputStream.genHuffTree(var14_14, var13_13);
                ZipOutputStream.revHuffTree(var14_14, var13_13);
                var15_16 = new short[76];
                ZipOutputStream.convertTable2Tree(var14_14, var13_13, var12_12, var15_16);
                var16_17 = 0;
                while (var16_17 < var10_6.length) {
                    var10_6[var16_17] = 0;
                    ++var16_17;
                }
                var16_17 = 0;
                while (var16_17 < var7_3.length) {
                    var7_3[var16_17] = 0;
                    ++var16_17;
                }
                var16_17 = 0;
                var17_18 = 0;
                while (var17_18 < var2_9 + 257 + var3_10 + 1) {
                    if (this.smallCodeBuffer[1] < 15L) {
                        this.refillSmallCodeBuffer();
                    }
                    if ((var1_19 = ZipOutputStream.deHuffNext(this.smallCodeBuffer, var15_16)) < 16) {
                        var16_17 = (byte)var1_19;
                        var1_19 = 1;
                    } else if (var1_19 == 16) {
                        var1_19 = this.popSmallBuffer(2L) + 3;
                    } else if (var1_19 == 17) {
                        var16_17 = 0;
                        var1_19 = this.popSmallBuffer(3L) + 3;
                    } else if (var1_19 == 18) {
                        var16_17 = 0;
                        var1_19 = this.popSmallBuffer(7L) + 11;
                    }
                    var18_21 = 0;
                    while (var18_21 < var1_19) {
                        if (var17_18 < var2_9 + 257) {
                            var10_6[var17_18] = var16_17;
                        } else {
                            var7_3[var17_18 - (var2_9 + 257)] = var16_17;
                        }
                        ++var18_21;
                        ++var17_18;
                    }
                }
                ZipOutputStream.genHuffTree(var8_4, var10_6);
                var17_18 = 0;
                while (var17_18 < var9_5.length) {
                    var9_5[var17_18] = var17_18;
                    ++var17_18;
                }
                ZipOutputStream.revHuffTree(var8_4, var10_6);
                ZipOutputStream.convertTable2Tree(var8_4, var10_6, var9_5, this.huffmanTree);
                var17_18 = 0;
                while (var17_18 < var5_1.length) {
                    var6_2[var17_18] = var17_18;
                    ++var17_18;
                }
                ZipOutputStream.genHuffTree(var5_1, var7_3);
                ZipOutputStream.revHuffTree(var5_1, var7_3);
                ZipOutputStream.convertTable2Tree(var5_1, var7_3, var6_2, this.distHuffTree);
                break block23;
            }
            this.popSmallBuffer(this.smallCodeBuffer[1] & 7L);
            this.B0len = this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8;
            if (this.smallCodeBuffer[1] < 15L) {
                this.refillSmallCodeBuffer();
            }
            if (this.B0len + (this.popSmallBuffer(8L) | this.popSmallBuffer(8L) << 8) == 65535) ** GOTO lbl152
            throw new IOException("3");
lbl-1000:
            // 1 sources

            {
                var1_20 = this.popSmallBuffer(8L);
                this.window[this.pProcessed] = (byte)var1_20;
                this.pProcessed = this.pProcessed + 1 & 32767;
                this.outBuff[this.outEnd] = (byte)var1_20;
                ++this.outEnd;
                --this.B0len;
lbl152:
                // 2 sources

                ** while (this.smallCodeBuffer[1] != 0L && this.B0len > 0)
            }
        }
        this.status = 1;
        var5_1 = null;
        var6_2 = null;
        var7_3 = null;
        var10_6 = null;
        var8_4 = null;
        var9_5 = null;
    }

    public int validData() throws IOException {
        this.inflate();
        if (this.status != 3) {
            return -1;
        }
        return 1;
    }

    private int popSmallBuffer(long l) throws IOException {
        if (l == 0L) {
            return 0;
        }
        if (this.smallCodeBuffer[1] < l) {
            this.refillSmallCodeBuffer();
        }
        int n = (int)(this.smallCodeBuffer[0] & (long)((1 << (int)l) - 1));
        this.smallCodeBuffer[0] = this.smallCodeBuffer[0] >>> (int)l;
        this.smallCodeBuffer[1] = this.smallCodeBuffer[1] - l;
        return n;
    }

    private void refillSmallCodeBuffer() throws IOException {
        if (!this.inStreamEnded) {
            int n = (int)(8L - this.smallCodeBuffer[1] / 8L - 1L);
            int n2 = this.readbuf(this.tmpRef, 0, n);
            if (n2 == -1) {
                this.inStreamEnded = true;
            }
            int n3 = 0;
            while (n3 < n2) {
                this.smallCodeBuffer[0] = this.smallCodeBuffer[0] & (255L << (int)this.smallCodeBuffer[1] ^ 0xFFFFFFFFFFFFFFFFL);
                this.smallCodeBuffer[0] = this.tmpRef[n3] < 0 ? this.smallCodeBuffer[0] | (long)(this.tmpRef[n3] + 256) << (int)this.smallCodeBuffer[1] : this.smallCodeBuffer[0] | (long)this.tmpRef[n3] << (int)this.smallCodeBuffer[1];
                this.smallCodeBuffer[1] = this.smallCodeBuffer[1] + 8L;
                ++n3;
            }
        }
    }

    public int available() throws IOException {
        if (this.outEnd - this.outStart < this.outBuff.length - 300) {
            this.inflate();
        }
        return this.outEnd - this.outStart;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        byte[] byArray = new byte[this.buffsize];
        while (l2 < l && this.status != 3) {
            l2 += (long)this.read(byArray);
        }
        return l2;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.outEnd - this.outStart < this.outBuff.length - 300) {
            this.inflate();
        }
        int n4 = n2 > (n3 = this.available()) ? n3 : n2;
        System.arraycopy(this.outBuff, this.outStart, byArray, n, n4);
        this.outStart += n4;
        if (n4 != 0) {
            return n4;
        }
        return -1;
    }

    void setOffset(int n) {
        this.offset = n;
    }

    private int checkFileEOF(int n) {
        int n2 = this.datalen - this.offset;
        return n2 == 0 ? -1 : (n > n2 ? n2 : n);
    }

    private void ContDataInputStream(byte[] byArray, int n) {
        this.offset = 0;
        this.bytes = byArray;
        this.datalen = n;
    }

    int getOffst() {
        return this.offset;
    }

    private void readFully(byte[] byArray, int n, int n2) {
        if ((n2 = this.checkFileEOF(n2)) > 0) {
            System.arraycopy(this.bytes, this.offset, byArray, n, n2);
            this.offset += n2;
        }
    }

    void skipbuf(int n) {
        this.offset += n;
    }

    private int readbuf(byte[] byArray, int n, int n2) {
        if ((n2 = this.checkFileEOF(n2)) > 0) {
            System.arraycopy(this.bytes, this.offset, byArray, n, n2);
            this.offset += n2;
        }
        return n2;
    }

    private int readbuf() {
        return this.bytes[this.offset++] & 0xFF;
    }

    private int readInt() {
        return (this.bytes[this.offset++] & 0xFF) << 24 | (this.bytes[this.offset++] & 0xFF) << 16 | (this.bytes[this.offset++] & 0xFF) << 8 | this.bytes[this.offset++] & 0xFF;
    }

    int readLshort() {
        return this.bytes[this.offset++] & 0xFF | (this.bytes[this.offset++] & 0xFF) << 8;
    }

    private int readLint() {
        return this.bytes[this.offset++] & 0xFF | (this.bytes[this.offset++] & 0xFF) << 8 | (this.bytes[this.offset++] & 0xFF) << 16 | (this.bytes[this.offset++] & 0xFF) << 24;
    }

    private boolean endsys() {
        byte[] byArray = this.bytes;
        int n = this.datalen - 22;
        while (n > 0) {
            if (byArray[n] == 80 && byArray[n + 1] == 75 && byArray[n + 2] == 5 && byArray[n + 3] == 6) break;
            --n;
        }
        if (n < 20) {
            return false;
        }
        this.setOffset(n + 16);
        this.setOffset(this.readLint());
        Vector<Object> vector = this.entries = new Vector<Object>();
        vector.addElement(this);
        while (this.readInt() == 1347092738) {
            ZipEntry zipEntry = new ZipEntry(null);
            this.skipbuf(4);
            zipEntry.flag = this.readLshort();
            zipEntry.setMethod(this.readLshort());
            zipEntry.dostime = this.readLint();
            zipEntry.crc = this.readLint();
            zipEntry.compressedSize = this.readLint();
            zipEntry.size = this.readLint();
            zipEntry.namelen = this.readLshort();
            int n2 = this.readLshort();
            int n3 = this.readLshort();
            this.skipbuf(8);
            zipEntry.offset = this.readLint();
            zipEntry.setname(this.bytes, this.getOffst(), zipEntry.namelen);
            this.skipbuf(zipEntry.namelen);
            if (!zipEntry.isDirectory()) {
                if (zipEntry.name.equals("META-INF/MANIFEST.MF")) {
                    vector.setElementAt(zipEntry, 0);
                } else {
                    vector.addElement(zipEntry);
                }
            }
            this.skipbuf(n2 + n3);
        }
        return true;
    }

    public Vector getEntrys() {
        return this.entries;
    }

    public byte[] getData(ZipEntry zipEntry) {
        this.setOffset(zipEntry.offset + 26);
        byte[] byArray = null;
        try {
            int n = zipEntry.size;
            byArray = new byte[n];
            this.skipbuf(this.readLshort() + this.readLshort());
            if (zipEntry.method == 8) {
                this.inf_reset();
                int n2 = 0;
                while (n - n2 > 0) {
                    n2 += this.read(byArray, n2, n - n2);
                }
            } else {
                this.readFully(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return byArray;
    }
}

