/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public final class ZipOutputStream {
    private static final int TYPE_GZIP = 1;
    private byte[] outputWindow;
    private byte[] plainDataWindow;
    private int outProcessed;
    private int plainPointer;
    private static final int HASHMAP_COUNT = 4;
    IntShortHashMap[] HM;
    private byte[] inputBuffer;
    private int inEnd;
    private int inStart;
    private int[] smallCodeBuffer;
    int[] huffmanCode;
    byte[] huffmanCodeLength;
    int[] distHuffCode;
    byte[] distHuffCodeLength;
    private int[] litCount;
    private int[] distCount;
    private int status;
    private static final int STREAM_INIT = 0;
    private static final int STREAMING = 4;
    private boolean lastBlock;
    private boolean lz77active;
    private int BTYPE;
    private static final boolean debug = false;
    private static final boolean GZIP = false;
    private static final int[] crctable;
    private boolean zipFile;
    private FileConnection fc;
    static final int[] LENGTH_CODE;
    static final int[] DISTANCE_CODE;
    private Vector entries;
    private int crc;
    private ZipEntry curEntry;
    private int curMethod;
    private int size;
    private int entryoffset;
    OutputStream outbuf;
    byte[] bytes;
    private int bufoff;
    private int offset;

    static {
        int[] nArray = crctable = new int[256];
        int n = 0;
        while (n < 256) {
            int n2 = n;
            int n3 = 8;
            while (--n3 >= 0) {
                if ((n2 & 1) != 0) {
                    n2 = 0xEDB88320 ^ n2 >>> 1;
                    continue;
                }
                n2 >>>= 1;
            }
            nArray[n] = n2;
            ++n;
        }
        int[] nArray2 = new int[58];
        nArray2[1] = 3;
        nArray2[3] = 4;
        nArray2[5] = 5;
        nArray2[7] = 6;
        nArray2[9] = 7;
        nArray2[11] = 8;
        nArray2[13] = 9;
        nArray2[15] = 10;
        nArray2[16] = 1;
        nArray2[17] = 11;
        nArray2[18] = 1;
        nArray2[19] = 13;
        nArray2[20] = 1;
        nArray2[21] = 15;
        nArray2[22] = 1;
        nArray2[23] = 17;
        nArray2[24] = 2;
        nArray2[25] = 19;
        nArray2[26] = 2;
        nArray2[27] = 23;
        nArray2[28] = 2;
        nArray2[29] = 27;
        nArray2[30] = 2;
        nArray2[31] = 31;
        nArray2[32] = 3;
        nArray2[33] = 35;
        nArray2[34] = 3;
        nArray2[35] = 43;
        nArray2[36] = 3;
        nArray2[37] = 51;
        nArray2[38] = 3;
        nArray2[39] = 59;
        nArray2[40] = 4;
        nArray2[41] = 67;
        nArray2[42] = 4;
        nArray2[43] = 83;
        nArray2[44] = 4;
        nArray2[45] = 99;
        nArray2[46] = 4;
        nArray2[47] = 115;
        nArray2[48] = 5;
        nArray2[49] = 131;
        nArray2[50] = 5;
        nArray2[51] = 163;
        nArray2[52] = 5;
        nArray2[53] = 195;
        nArray2[54] = 5;
        nArray2[55] = 227;
        nArray2[57] = 258;
        LENGTH_CODE = nArray2;
        int[] nArray3 = new int[60];
        nArray3[1] = 1;
        nArray3[3] = 2;
        nArray3[5] = 3;
        nArray3[7] = 4;
        nArray3[8] = 1;
        nArray3[9] = 5;
        nArray3[10] = 1;
        nArray3[11] = 7;
        nArray3[12] = 2;
        nArray3[13] = 9;
        nArray3[14] = 2;
        nArray3[15] = 13;
        nArray3[16] = 3;
        nArray3[17] = 17;
        nArray3[18] = 3;
        nArray3[19] = 25;
        nArray3[20] = 4;
        nArray3[21] = 33;
        nArray3[22] = 4;
        nArray3[23] = 49;
        nArray3[24] = 5;
        nArray3[25] = 65;
        nArray3[26] = 5;
        nArray3[27] = 97;
        nArray3[28] = 6;
        nArray3[29] = 129;
        nArray3[30] = 6;
        nArray3[31] = 193;
        nArray3[32] = 7;
        nArray3[33] = 257;
        nArray3[34] = 7;
        nArray3[35] = 385;
        nArray3[36] = 8;
        nArray3[37] = 513;
        nArray3[38] = 8;
        nArray3[39] = 769;
        nArray3[40] = 9;
        nArray3[41] = 1025;
        nArray3[42] = 9;
        nArray3[43] = 1537;
        nArray3[44] = 10;
        nArray3[45] = 2049;
        nArray3[46] = 10;
        nArray3[47] = 3073;
        nArray3[48] = 11;
        nArray3[49] = 4097;
        nArray3[50] = 11;
        nArray3[51] = 6145;
        nArray3[52] = 12;
        nArray3[53] = 8193;
        nArray3[54] = 12;
        nArray3[55] = 12289;
        nArray3[56] = 13;
        nArray3[57] = 16385;
        nArray3[58] = 13;
        nArray3[59] = 24577;
        DISTANCE_CODE = nArray3;
    }

    static int updateCRC(int n, byte[] byArray, int n2, int n3) {
        int n4 = ~n;
        int[] nArray = crctable;
        while (--n3 >= 0) {
            n4 = nArray[(n4 ^ byArray[n2++]) & 0xFF] ^ n4 >>> 8;
        }
        return ~n4;
    }

    public ZipOutputStream(String string) throws IOException {
        boolean bl;
        block11: {
            this.HM = new IntShortHashMap[5];
            FileConnection fileConnection = null;
            bl = false;
            try {
                fileConnection = (FileConnection)Connector.open((String)string, (int)2);
                if (fileConnection == null) break block11;
                try {
                    fileConnection.truncate(0L);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        fileConnection.create();
                        bl = true;
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                if (bl) {
                    this.fc = fileConnection;
                    this.init(this.fc.openOutputStream(), 1024, 0, 32768, 8192, 32768, true);
                } else {
                    fileConnection.close();
                }
            }
            catch (Throwable throwable) {
                if (fileConnection == null) break block11;
                try {
                    fileConnection.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
            }
        }
        if (!bl) {
            throw new IOException();
        }
    }

    private void def_reset() throws IOException {
        this.BTYPE = 2;
        this.status = 0;
        int n = 0;
        while (n < 4) {
            this.HM[n] = new IntShortHashMap(2048);
            ++n;
        }
        this.lastBlock = false;
    }

    private void init(OutputStream outputStream, int n, int n2, int n3, int n4, int n5, boolean bl) throws IOException {
        this.BufDataOutputStream(outputStream, n5);
        this.curMethod = 8;
        this.zipFile = bl;
        if (this.zipFile) {
            this.entries = new Vector();
        }
        this.curEntry = null;
        this.smallCodeBuffer = new int[2];
        this.inputBuffer = new byte[n + 300];
        this.litCount = new int[286];
        this.distCount = new int[30];
        this.plainDataWindow = new byte[n3 / 4 * 4];
        this.lz77active = true;
        if (n4 < 1024 && n4 > 0) {
            n4 = 1024;
        }
        this.outputWindow = new byte[n4];
        this.def_reset();
    }

    public ZipOutputStream(OutputStream outputStream, int n, int n2, int n3, int n4, int n5, boolean bl) throws IOException {
        this.HM = new IntShortHashMap[5];
        this.init(outputStream, n, n2, n3, n4, n5, bl);
    }

    public void Def_close() throws IOException {
        this.Def_flush();
        if (this.BTYPE == 2) {
            if (this.outProcessed + 8 + (this.inEnd - this.inStart) * 8 / 3 > this.outputWindow.length) {
                this.compileOutput();
            }
            this.LZ77(true);
            this.lastBlock = true;
            this.compileOutput();
        } else {
            this.LZ77(true);
        }
        this.writeFooter();
    }

    public void Def_flush() throws IOException {
        this.LZ77(false);
    }

    public void Def_write(byte[] byArray) throws IOException {
        this.Def_write(byArray, 0, byArray.length);
    }

    public void Def_write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        this.crc = ZipOutputStream.updateCRC(this.crc, byArray, n, n2);
        while (n3 != n2) {
            if (this.inputBuffer.length - this.inEnd >= n2 - n3) {
                System.arraycopy(byArray, n3 + n, this.inputBuffer, this.inEnd, n2 - n3);
                this.inEnd += n2 - n3;
                n3 = n2;
            } else {
                System.arraycopy(byArray, n3 + n, this.inputBuffer, this.inEnd, this.inputBuffer.length - this.inEnd);
                n3 += this.inputBuffer.length - this.inEnd;
                this.inEnd = this.inputBuffer.length;
            }
            this.LZ77(false);
        }
    }

    private boolean search4LZ77(int[] nArray, int n) {
        IntShortHashMap.Element element = null;
        int[] nArray2 = new int[2];
        nArray[1] = 0;
        int n2 = 0;
        while (n2 < 4) {
            element = null;
            element = this.HM[n2].get(128 + this.inputBuffer[n] << 16 | 128 + this.inputBuffer[n + 1] << 8 | 128 + this.inputBuffer[n + 2]);
            if (element != null && element.size != 0) {
                this.searchHM4LZ77(element, nArray2, n);
                if (nArray2[1] > nArray[1]) {
                    nArray[0] = nArray2[0];
                    nArray[1] = nArray2[1];
                }
            }
            ++n2;
        }
        return nArray[1] != 0;
    }

    private void searchHM4LZ77(IntShortHashMap.Element element, int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = element.size - 1;
        while (n4 >= 0) {
            int n5 = 3;
            int n6 = 100000;
            while (n5 < 258 && n + n5 < this.inputBuffer.length) {
                n6 = element.values[n4] < this.plainPointer ? (element.values[n4] + n5 % (this.plainPointer - element.values[n4])) % this.plainDataWindow.length : (element.values[n4] + n5 % (this.plainPointer + this.plainDataWindow.length - element.values[n4])) % this.plainDataWindow.length;
                if (this.inputBuffer[n + n5] != this.plainDataWindow[n6]) break;
                ++n5;
            }
            if (n5 > n3) {
                n2 = n4;
                n3 = n5;
                if (n5 == 258) break;
            }
            --n4;
        }
        nArray[0] = (this.plainPointer - element.values[n2] + this.plainDataWindow.length) % this.plainDataWindow.length;
        nArray[1] = n3;
    }

    private void encodePointer(int n, int n2) throws IOException {
        int n3 = ZipOutputStream.encodeCode(LENGTH_CODE, n2);
        int n4 = 257 + n3;
        byte by = (byte)(n2 - LENGTH_CODE[n3 * 2 + 1]);
        n3 = ZipOutputStream.encodeCode(DISTANCE_CODE, n);
        int n5 = n - DISTANCE_CODE[n3 * 2 + 1];
        if (this.outputWindow.length != 0) {
            this.outputWindow[this.outProcessed] = -1;
            this.outputWindow[this.outProcessed + 1] = (byte)(n4 - 255);
            this.outputWindow[this.outProcessed + 2] = by;
            this.outputWindow[this.outProcessed + 3] = (byte)n3;
            this.outputWindow[this.outProcessed + 4] = (byte)(n5 & 0xFF);
            this.outputWindow[this.outProcessed + 5] = (byte)(n5 >> 8 & 0xFF);
            this.outputWindow[this.outProcessed + 6] = (byte)(n5 >> 16 & 0xFF);
            this.outProcessed += 6;
            int n6 = n4;
            this.litCount[n6] = this.litCount[n6] + 1;
            int n7 = n3;
            this.distCount[n7] = this.distCount[n7] + 1;
        } else {
            this.pushSmallBuffer(this.huffmanCode[n4], this.huffmanCodeLength[n4]);
            this.pushSmallBuffer(by, (byte)LENGTH_CODE[2 * (n4 - 257)]);
            this.pushSmallBuffer(this.distHuffCode[n3], this.distHuffCodeLength[n3]);
            this.pushSmallBuffer(n5, (byte)DISTANCE_CODE[n3 * 2]);
        }
    }

    private void encodeChar(int n) throws IOException {
        int n2 = this.inputBuffer[n] + 256 & 0xFF;
        if (this.outputWindow.length != 0) {
            int n3 = n2;
            this.litCount[n3] = this.litCount[n3] + 1;
            this.outputWindow[this.outProcessed] = (byte)n2;
            if (n2 == 255) {
                ++this.outProcessed;
                this.outputWindow[this.outProcessed] = 0;
            }
        } else {
            this.pushSmallBuffer(this.huffmanCode[n2], this.huffmanCodeLength[n2]);
        }
    }

    private void LZ77(boolean bl) throws IOException {
        if (this.inStart != 0) {
            System.arraycopy(this.inputBuffer, this.inStart, this.inputBuffer, 0, this.inEnd - this.inStart);
            this.inEnd -= this.inStart;
            this.inStart = 0;
        }
        int n = bl ? this.inEnd : this.inEnd - 300;
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 1;
            int n4 = 0;
            if (this.lz77active && n2 < n - 2 && this.search4LZ77(nArray, n2)) {
                if (nArray[1] > nArray2[1]) {
                    nArray2[0] = nArray[0];
                    nArray2[1] = nArray[1];
                } else {
                    n4 = nArray[0];
                    n3 = nArray[1];
                }
            }
            if (bl && n - n2 < n3) {
                n3 = n - n2;
            }
            if (n3 > 2) {
                this.encodePointer(n4, n3);
            } else {
                this.encodeChar(n2);
            }
            if (this.outputWindow.length != 0) {
                ++this.outProcessed;
                if (this.outProcessed + 8 > this.outputWindow.length) {
                    this.compileOutput();
                }
            }
            if (this.lz77active) {
                int n5 = 0;
                while (n5 < n3) {
                    this.plainDataWindow[this.plainPointer] = this.inputBuffer[n2 + n5];
                    this.HM[this.plainPointer / (this.plainDataWindow.length / 4)].put(128 + this.inputBuffer[n2 + n5] << 16 | 128 + this.inputBuffer[n2 + n5 + 1] << 8 | 128 + this.inputBuffer[n2 + n5 + 2], (short)this.plainPointer);
                    if (++this.plainPointer % (this.plainDataWindow.length / 4) == 0) {
                        if (this.plainPointer == this.plainDataWindow.length) {
                            this.plainPointer = 0;
                        }
                        this.HM[this.plainPointer / (this.plainDataWindow.length / 4) % 4].clear();
                    }
                    ++n5;
                }
            }
            n2 += n3;
        }
        this.inStart = n2;
    }

    private void newBlock() throws IOException {
        if (this.status == 0) {
            this.status = 4;
        } else {
            this.pushSmallBuffer(this.huffmanCode[256], this.huffmanCodeLength[256]);
        }
        if (this.lastBlock) {
            this.pushSmallBuffer(1, (byte)1);
        } else {
            this.pushSmallBuffer(0, (byte)1);
        }
        this.pushSmallBuffer(this.BTYPE, (byte)2);
        this.huffmanCode = new int[286];
        this.huffmanCodeLength = new byte[286];
        this.distHuffCode = new int[30];
        this.distHuffCodeLength = new byte[30];
        if (this.BTYPE == 1) {
            ZipOutputStream.genFixedTree(this.huffmanCode, this.huffmanCodeLength, this.distHuffCode, this.distHuffCodeLength);
        } else if (this.BTYPE == 2) {
            int n = 0;
            while (n < 2) {
                if (this.distCount[n] == 0) {
                    this.distCount[n] = 1;
                }
                ++n;
            }
            this.litCount[256] = 1;
            ZipOutputStream.genTreeLength(this.litCount, this.huffmanCodeLength, 15);
            ZipOutputStream.genHuffTree(this.huffmanCode, this.huffmanCodeLength);
            ZipOutputStream.revHuffTree(this.huffmanCode, this.huffmanCodeLength);
            ZipOutputStream.genTreeLength(this.distCount, this.distHuffCodeLength, 15);
            ZipOutputStream.genHuffTree(this.distHuffCode, this.distHuffCodeLength);
            ZipOutputStream.revHuffTree(this.distHuffCode, this.distHuffCodeLength);
            this.compressTree(this.huffmanCodeLength, this.distHuffCodeLength);
            n = 0;
            while (n < 286) {
                this.litCount[n] = 0;
                ++n;
            }
            n = 0;
            while (n < 30) {
                this.distCount[n] = 0;
                ++n;
            }
        }
    }

    private void compileOutput() throws IOException {
        this.newBlock();
        int n = 0;
        int n2 = 0;
        while (n2 < this.outProcessed) {
            n = this.outputWindow[n2];
            if (n < 0) {
                n += 256;
            }
            if (n != 255) {
                this.pushSmallBuffer(this.huffmanCode[n], this.huffmanCodeLength[n]);
            } else if (n == 255) {
                if (this.outputWindow[++n2] == 0) {
                    this.pushSmallBuffer(this.huffmanCode[255], this.huffmanCodeLength[255]);
                } else if (this.outputWindow[n2] > 0) {
                    int n3 = 255 + this.outputWindow[n2];
                    byte by = this.outputWindow[++n2];
                    byte by2 = this.outputWindow[++n2];
                    int n4 = this.outputWindow[++n2] + 256 & 0xFF | (this.outputWindow[n2 + 1] + 256 & 0xFF) << 8 | (this.outputWindow[n2 + 2] + 256 & 0xFF) << 16;
                    n2 += 3;
                    this.pushSmallBuffer(this.huffmanCode[n3], this.huffmanCodeLength[n3]);
                    this.pushSmallBuffer(by, (byte)LENGTH_CODE[2 * (n3 - 257)]);
                    this.pushSmallBuffer(this.distHuffCode[by2], this.distHuffCodeLength[by2]);
                    this.pushSmallBuffer(n4, (byte)DISTANCE_CODE[by2 * 2]);
                    --n2;
                } else {
                    throw new IOException("illegal code decoded");
                }
            }
            ++n2;
        }
        this.outProcessed = 0;
    }

    private void writeFooter() throws IOException {
        this.pushSmallBuffer(this.huffmanCode[256], this.huffmanCodeLength[256]);
        if ((this.smallCodeBuffer[1] & 7) != 0) {
            this.pushSmallBuffer(0, (byte)(8 - (this.smallCodeBuffer[1] & 7)));
        }
        if (!this.zipFile) {
            this.writeLint(this.crc);
            this.writeLint(this.size);
            this.flushbuf();
            this.close();
        }
    }

    private void compressTree(byte[] byArray, byte[] byArray2) throws IOException {
        int n = 285;
        int n2 = 29;
        while (byArray[n] == 0 && n > 29) {
            --n;
        }
        ++n;
        while (byArray2[n2] == 0 && n2 > 0) {
            --n2;
        }
        byte[] byArray3 = new byte[n + ++n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            byArray3[n3] = byArray[n4];
            ++n3;
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            byArray3[n3] = byArray2[n4];
            ++n3;
            ++n4;
        }
        int[] nArray = new int[19];
        nArray[0] = 16;
        nArray[1] = 17;
        nArray[2] = 18;
        nArray[4] = 8;
        nArray[5] = 7;
        nArray[6] = 9;
        nArray[7] = 6;
        nArray[8] = 10;
        nArray[9] = 5;
        nArray[10] = 11;
        nArray[11] = 4;
        nArray[12] = 12;
        nArray[13] = 3;
        nArray[14] = 13;
        nArray[15] = 2;
        nArray[16] = 14;
        nArray[17] = 1;
        nArray[18] = 15;
        int[] nArray2 = nArray;
        byte[] byArray4 = new byte[n + n2];
        int n5 = 0;
        int[] nArray3 = new int[19];
        int n6 = 0;
        while (n6 < byArray3.length) {
            if (n6 + 3 < byArray3.length && byArray3[n6] == byArray3[n6 + 1] && byArray3[n6] == byArray3[n6 + 2] && byArray3[n6] == byArray3[n6 + 3]) {
                int n7;
                if (byArray3[n6] == 0) {
                    byArray4[n5] = 0;
                    n7 = 4;
                    while (n6 + n7 < byArray3.length && byArray3[n6] == byArray3[n6 + n7] && n7 < 139) {
                        n7 = (short)(n7 + 1);
                    }
                    if (n7 < 12) {
                        byArray4[n5 + 1] = 17;
                        byArray4[n5 + 2] = (byte)(n7 - 3 - 1);
                    } else {
                        byArray4[n5 + 1] = 18;
                        byArray4[n5 + 2] = (byte)(n7 - 11 - 1);
                    }
                    n6 += n7 - 1;
                } else {
                    byArray4[n5] = byArray3[n6];
                    byArray4[n5 + 1] = 16;
                    n7 = 4;
                    while (n6 + n7 < byArray3.length && byArray3[n6] == byArray3[n6 + n7] && n7 < 7) {
                        n7 = (short)(n7 + 1);
                    }
                    byArray4[n5 + 2] = (byte)(n7 - 4);
                    n6 += n7 - 1;
                }
                byte by = byArray4[n5];
                nArray3[by] = nArray3[by] + 1;
                byte by2 = byArray4[n5 + 1];
                nArray3[by2] = nArray3[by2] + 1;
                n5 += 2;
            } else {
                byArray4[n5] = byArray3[n6];
                byte by = byArray4[n5];
                nArray3[by] = nArray3[by] + 1;
            }
            ++n5;
            ++n6;
        }
        byte[] byArray5 = new byte[19];
        int[] nArray4 = new int[19];
        int n8 = 0;
        ZipOutputStream.genTreeLength(nArray3, byArray5, 7);
        ZipOutputStream.genHuffTree(nArray4, byArray5);
        ZipOutputStream.revHuffTree(nArray4, byArray5);
        this.pushSmallBuffer(n - 257, (byte)5);
        this.pushSmallBuffer(n2 - 1, (byte)5);
        int n9 = 18;
        while (byArray5[nArray2[n9]] == 0 && n9 > 0) {
            --n9;
        }
        this.pushSmallBuffer(++n9 - 4, (byte)4);
        n8 = 0;
        while (n8 < n9) {
            this.pushSmallBuffer(byArray5[nArray2[n8]], (byte)3);
            ++n8;
        }
        n8 = 0;
        while (n8 < n5) {
            this.pushSmallBuffer(nArray4[byArray4[n8]], byArray5[byArray4[n8]]);
            if (byArray4[n8] > 15) {
                switch (byArray4[n8]) {
                    case 16: {
                        this.pushSmallBuffer(byArray4[n8 + 1], (byte)2);
                        ++n8;
                        break;
                    }
                    case 17: {
                        this.pushSmallBuffer(byArray4[n8 + 1], (byte)3);
                        ++n8;
                        break;
                    }
                    default: {
                        this.pushSmallBuffer(byArray4[n8 + 1], (byte)7);
                        ++n8;
                    }
                }
            }
            ++n8;
        }
    }

    private void pushSmallBuffer(int n, byte by) throws IOException {
        int n2 = this.smallCodeBuffer[0];
        int n3 = this.smallCodeBuffer[1];
        n2 &= ~((1 << by) - 1 << n3);
        n2 |= n << n3;
        n3 += by;
        while (n3 >= 8) {
            this.writebuf(n2 & 0xFF);
            n2 >>>= 8;
            n3 -= 8;
        }
        this.smallCodeBuffer[0] = n2;
        this.smallCodeBuffer[1] = n3;
    }

    static int encodeCode(int[] nArray, int n) {
        int n2 = 0;
        while (n2 < nArray.length >> 1 && n >= nArray[(n2 << 1) + 1]) {
            ++n2;
        }
        return n2 - 1;
    }

    static void genHuffTree(int[] nArray, byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            n = byArray[n3];
            n2 = n2 > n ? n2 : n;
            ++n3;
        }
        short[] sArray = new short[++n2];
        n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            sArray[by] = (short)(sArray[by] + 1);
            ++n;
        }
        n = 0;
        int[] nArray2 = new int[n2];
        sArray[0] = 0;
        int n4 = 1;
        while (n4 < n2) {
            nArray2[n4] = n = n + sArray[n4 - 1] << 1;
            ++n4;
        }
        n4 = 0;
        while (n4 < nArray.length) {
            byte by = byArray[n4];
            if (by != 0) {
                nArray[n4] = nArray2[by];
                byte by2 = by;
                nArray2[by2] = nArray2[by2] + 1;
            }
            ++n4;
        }
    }

    static void revHuffTree(int[] nArray, byte[] byArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < byArray[n]) {
                n3 |= n2 >>> n4 & 1;
                n3 <<= 1;
                ++n4;
            }
            nArray[n] = n3 >>> 1;
            ++n;
        }
    }

    static void genFixedTree(int[] nArray, byte[] byArray, int[] nArray2, byte[] byArray2) {
        int n = 0;
        while (n <= 143) {
            nArray[n] = 48 + n;
            byArray[n] = 8;
            ++n;
        }
        n = 144;
        while (n <= 255) {
            nArray[n] = 400 + n - 144;
            byArray[n] = 9;
            ++n;
        }
        n = 256;
        while (n <= 279) {
            nArray[n] = n - 256;
            byArray[n] = 7;
            ++n;
        }
        n = 280;
        while (n < 286) {
            nArray[n] = 192 + n - 280;
            byArray[n] = 8;
            ++n;
        }
        ZipOutputStream.revHuffTree(nArray, byArray);
        int n2 = 0;
        while (n2 < nArray2.length) {
            nArray2[n2] = n2;
            byArray2[n2] = 5;
            ++n2;
        }
        ZipOutputStream.revHuffTree(nArray2, byArray2);
    }

    static void genTreeLength(int[] nArray, byte[] byArray, int n) {
        int n2;
        int n3;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray2[n4] = nArray[n4] != 0 ? nArray[n4] : Integer.MAX_VALUE;
            nArray3[n4] = n4;
            n4 = (short)(n4 + 1);
        }
        n4 = 0;
        int n5 = 0;
        block1: while (true) {
            if (nArray2[0] < nArray2[1]) {
                n4 = 0;
                n5 = 1;
            } else {
                n4 = 1;
                n5 = 0;
            }
            n3 = 2;
            while (n3 < nArray.length) {
                if (nArray2[n3] < nArray2[n4]) {
                    n5 = n4;
                    n4 = n3;
                } else if (nArray2[n3] < nArray2[n5]) {
                    n5 = n3;
                }
                ++n3;
            }
            if (nArray2[n5] == Integer.MAX_VALUE) break;
            int n6 = n4;
            nArray2[n6] = nArray2[n6] + nArray2[n5];
            n3 = nArray3[n5];
            nArray2[n5] = Integer.MAX_VALUE;
            n2 = 0;
            while (true) {
                if (n2 >= nArray.length) continue block1;
                if (nArray3[n2] == n3) {
                    nArray3[n2] = nArray3[n4];
                    int n7 = n2;
                    byArray[n7] = (byte)(byArray[n7] + 1);
                } else if (nArray3[n2] == nArray3[n4]) {
                    int n8 = n2;
                    byArray[n8] = (byte)(byArray[n8] + 1);
                }
                ++n2;
            }
            break;
        }
        n3 = 0;
        n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] > n) {
                ++n3;
            }
            ++n2;
        }
        if (n3 != 0) {
            short[] sArray = new short[n3];
            n3 = 0;
            int n9 = 0;
            while (n9 < byArray.length) {
                if (byArray[n9] > n) {
                    sArray[n3++] = n9;
                }
                n9 = (short)(n9 + 1);
            }
            n9 = 0;
            int n10 = 0;
            while (n10 < byArray.length) {
                if (byArray[n10] != 0 && byArray[n9] > byArray[n10]) {
                    n9 = n10;
                }
                ++n10;
            }
            while (n3 != 0) {
                n10 = n9;
                int n11 = 0;
                while (n11 < byArray.length) {
                    if (byArray[n11] < n && byArray[n10] < byArray[n11]) {
                        n10 = n11;
                    }
                    ++n11;
                }
                int n12 = 0;
                int n13 = 0;
                n11 = 0;
                while (n11 < sArray.length) {
                    if (byArray[sArray[n11]] > byArray[n12]) {
                        n12 = sArray[n11];
                    } else if (byArray[sArray[n11]] == byArray[n12]) {
                        n13 = sArray[n11];
                    }
                    ++n11;
                }
                int n14 = n10;
                byArray[n14] = (byte)(byArray[n14] + 1);
                byArray[n12] = byArray[n10];
                int n15 = n13;
                byArray[n15] = (byte)(byArray[n15] - 1);
                --n3;
                if (byArray[n13] != n) continue;
                --n3;
            }
        }
    }

    static void convertTable2Tree(int[] nArray, byte[] byArray, int[] nArray2, short[] sArray) {
        int n = 0;
        while (n < sArray.length) {
            sArray[n] = 0;
            ++n;
        }
        int n2 = 1;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (byArray[n3] != 0) {
                n = 0;
                short s = 0;
                while (s < byArray[n3]) {
                    if (sArray[n * 2] == 0) {
                        int n4 = n2;
                        n2 = (short)(n4 + 1);
                        sArray[n * 2] = n4;
                        int n5 = n2;
                        n2 = (short)(n5 + 1);
                        sArray[n * 2 + 1] = n5;
                    }
                    n = sArray[n * 2 + (nArray[n3] >>> s & 1)];
                    s = (short)(s + 1);
                }
                if (n < 0) {
                    // empty if block
                }
                sArray[n * 2] = -1;
                sArray[n * 2 + 1] = (short)nArray2[n3];
            }
            n3 = (short)(n3 + 1);
        }
    }

    static int deHuffNext(long[] lArray, short[] sArray) throws IOException {
        int n = 0;
        while (sArray[n * 2] != -1) {
            n = sArray[n * 2 + (int)(lArray[0] & 1L)];
            lArray[0] = lArray[0] >>> 1;
            lArray[1] = lArray[1] - 1L;
            if (n != 0) continue;
            throw new IOException("5");
        }
        return sArray[n * 2 + 1];
    }

    public void putNextEntry(String string) throws Exception {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        this.putNextEntry(zipEntry);
    }

    public void putNextEntry(ZipEntry zipEntry) throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        zipEntry.flag = 8;
        zipEntry.setMethod(this.curMethod);
        this.curEntry = zipEntry;
        this.entries.addElement(zipEntry);
        zipEntry.offset = this.getoffse();
        this.writeLint(67324752);
        this.writeLshort(zipEntry.getMethod() == 0 ? 10 : 20);
        this.writeEntry(zipEntry);
        this.writebuf(zipEntry.getNamebytes());
        this.size = 0;
        this.crc = 0;
        this.def_reset();
        this.entryoffset = this.getoffse();
    }

    public void putFooEntry(ZipEntry zipEntry, ZipFile zipFile) throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        zipFile.setOffset(zipEntry.offset + 26);
        zipFile.skipbuf(zipFile.readLshort() + zipFile.readLshort());
        zipEntry.flag = 0;
        this.entries.addElement(zipEntry);
        zipEntry.offset = this.getoffse();
        this.writeLint(67324752);
        this.writeLshort(zipEntry.isDirectory() ? 10 : 20);
        this.writeEntry(zipEntry);
        this.writebuf(zipEntry.getNamebytes());
        this.writebuf(zipFile.bytes, zipFile.getOffst(), zipEntry.compressedSize);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void closeEntry() throws Exception {
        if (this.curEntry == null) {
            return;
        }
        if (this.curMethod == 8) {
            this.Def_close();
        }
        ZipEntry zipEntry = this.curEntry;
        zipEntry.size = this.size;
        int n = this.getoffse();
        zipEntry.compressedSize = n - this.entryoffset;
        zipEntry.crc = this.crc;
        if (!this.resetTo(zipEntry.offset + 6)) {
            this.writeLint(134695760);
            this.writeLint(zipEntry.crc);
            this.writeLint(zipEntry.compressedSize);
            this.writeLint(zipEntry.size);
        } else {
            zipEntry.flag = 0;
            this.writeEntry(zipEntry);
            this.skipto(n);
        }
        this.flushbuf();
        this.curEntry = null;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.curMethod == 0) {
            this.writebuf(byArray, n, n2);
            this.crc = ZipOutputStream.updateCRC(this.crc, byArray, n, n2);
        } else {
            this.Def_write(byArray, n, n2);
        }
        this.size += n2;
    }

    private void writeEntry(ZipEntry zipEntry) throws IOException {
        this.writeLshort(zipEntry.flag);
        this.writeLshort(zipEntry.getMethod());
        this.writeLint(zipEntry.dostime);
        this.writeLint(zipEntry.crc);
        this.writeLint(zipEntry.compressedSize);
        this.writeLint(zipEntry.size);
        this.writeLshort(zipEntry.namelen);
        this.writeLshort(0);
    }

    private void finish() throws Exception {
        if (this.curEntry != null) {
            this.closeEntry();
        }
        int n = this.getoffse();
        int n2 = 0;
        int n3 = this.entries.size();
        int n4 = 0;
        while (n4 < n3) {
            ZipEntry zipEntry = (ZipEntry)this.entries.elementAt(n4);
            this.writeLint(33639248);
            this.writeLshort(20);
            this.writeLshort(zipEntry.isDirectory() ? 10 : 20);
            this.writeEntry(zipEntry);
            this.writeLshort(0);
            this.writeLshort(0);
            this.writeLshort(0);
            this.writeLint(zipEntry.isDirectory() ? 1103101968 : -2122317792);
            this.writeLint(zipEntry.offset);
            this.writebuf(zipEntry.getNamebytes());
            n2 += 46 + zipEntry.namelen;
            ++n4;
        }
        this.writeLint(101010256);
        this.writeLint(0);
        this.writeLshort(n3);
        this.writeLshort(n3);
        this.writeLint(n2);
        this.writeLint(n);
        this.writeLshort(0);
        this.flushbuf();
        this.entries = null;
    }

    public void close() {
        try {
            if (this.zipFile && this.entries != null) {
                this.finish();
            } else {
                this.flushbuf();
            }
            this.bytes = null;
            this.outbuf.close();
            if (this.fc != null) {
                this.fc.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.outputWindow = null;
        this.inputBuffer = null;
        this.litCount = null;
    }

    private void BufDataOutputStream(OutputStream outputStream, int n) {
        this.outbuf = outputStream;
        this.bytes = new byte[n];
        this.bufoff = 0;
        this.offset = 0;
    }

    private boolean resetTo(int n) {
        int n2 = this.offset - n;
        if (n2 <= this.bufoff) {
            this.bufoff -= n2;
            this.offset = n;
            return true;
        }
        return false;
    }

    private int getoffse() {
        return this.offset;
    }

    private void skipto(int n) {
        this.bufoff += n - this.offset;
        this.offset = n;
    }

    private void flushbuf() throws IOException {
        if (this.bufoff > 0) {
            this.outbuf.write(this.bytes, 0, this.bufoff);
            this.bufoff = 0;
        }
    }

    private void writebuf(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (n2 < this.bytes.length - this.bufoff) {
            System.arraycopy(byArray, n, this.bytes, this.bufoff, n2);
            this.bufoff += n2;
        } else {
            this.flushbuf();
            this.outbuf.write(byArray, n, n2);
        }
        this.offset += n2;
    }

    private void writebuf(byte[] byArray) throws IOException {
        this.writebuf(byArray, 0, byArray.length);
    }

    private void writebuf(int n) throws IOException {
        if (this.bytes.length < this.bufoff + 1) {
            this.flushbuf();
        }
        ++this.offset;
        this.bytes[this.bufoff++] = (byte)n;
    }

    private void writeLshort(int n) throws IOException {
        if (this.bytes.length < this.bufoff + 2) {
            this.flushbuf();
        }
        this.offset += 2;
        this.bytes[this.bufoff++] = (byte)n;
        this.bytes[this.bufoff++] = (byte)(n >> 8);
    }

    private void writeLint(int n) throws IOException {
        if (this.bytes.length < this.bufoff + 4) {
            this.flushbuf();
        }
        this.offset += 4;
        this.bytes[this.bufoff++] = (byte)n;
        this.bytes[this.bufoff++] = (byte)(n >> 8);
        this.bytes[this.bufoff++] = (byte)(n >> 16);
        this.bytes[this.bufoff++] = (byte)(n >> 24);
    }
}

